/*------------------------------------------------------------------------------*
 * File Name: Collection.c	 													*
 * Creation: GJL 7/28/03														*
 * Purpose: OriginC Source C file containing Collection class examples.			*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007				*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <Collection.h>

// Lookup Origin windows in Pages collection of Project object
void PagesCollectionEx()
{
	PageBase pb0, pbData, pbActive;

	pb0 = Project.Pages(0); // Get the first page and output name
	if( pb0.IsValid() )
		printf("The first page in the project file is %s.\n", pb0.GetName());

	pbData = Project.Pages("Data2"); // Get the page named "Data2" and output name
	if( pbData.IsValid() )
		printf("The Data2 page is in fact named %s.\n", pbData.GetName());

	pbActive = Project.Pages(); // Get the active page and output name
	if( pbActive.IsValid() )
		printf("The active page in the project file is %s.\n", pbActive.GetName());

	// Output the number of pages in the project
	printf("The project %s contains %d pages.\n", Project.GetName(), Project.Pages.Count());
}

// Count the number of GraphLayers in an Origin project file 
void CountGraphLayersInProjectEx()
{
	// Initialize count
	int nCount = 0;
	// Use GraphPages collection in Project object to loop
	//   on all GraphPage objects in project file
	foreach( GraphPage gp in Project.GraphPages )
	{
		// Use Layers collection in GraphPage object to loop
		//   on all layers in each Graph page
		foreach( GraphLayer gl in gp.Layers )
		{
			nCount++; // Count layer
		}
	}
	printf("Total number of GraphLayers = %d\n",nCount);
}

// Walk a Tree outputting the string values of each TreeNode
void WalkATreeEx()
{
	Tree trRoot; // Declare and populate nodes of tree
	trRoot.Fruits.SubNode1.strVal = "Apples";
	trRoot.Fruits.SubNode2.strVal = "Pears";
	trRoot.Fruits.SubNode3.strVal = "Peaches";
	trRoot.Nuts.SubNode1.strVal = "Walnuts";
	trRoot.Nuts.SubNode2.strVal = "Cashews";
	trRoot.Nuts.SubNode3.strVal = "Peanuts";
	trRoot.Vegetables.SubNode1.strVal = "Carrots";
	trRoot.Vegetables.SubNode2.strVal = "Peas";
	trRoot.Vegetables.SubNode3.strVal = "Potatoes";

	// Declare an unattached Collection of TreeNode objects and attach
	// TreeNode Collection to collection of child nodes named Children
	Collection<TreeNode> tncFoods; // Declare
	tncFoods = trRoot.Children;    // Attach

	// Loop on all TreeNodes in TreeNode Collection tncFoods
	foreach( TreeNode tnParent in tncFoods )
	{
		string strParentName = tnParent.tagName;
		// Loop on all (sub)TreeNodes in TreeNode Collection tnParent.Children 
		foreach( TreeNode tnSubNode in tnParent.Children )
		{
			printf("trRoot.%s.%s.strVal = %s\n", strParentName, tnSubNode.tagName, tnSubNode.strVal);
		}
	}
}